Ext.define('Photoalbum.model.Image', {
    extend: 'Ext.data.Model',
    idgen: 'uuid',
    fields: [
             {name: 'id', type: 'string'},
             {name: 'picasaid', type: 'string'},
             {name: 'top', type: 'int'},
             {name: 'left', type: 'int'},
             {name: 'clicks', type: 'int', defaultValue: 0},
             {name: 'affinity', type: 'auto', defaultValue: []}
         ],
    hasMany: {
        model: 'Photoalbum.model.Picasa',
        name: 'picasa'
    },
    proxy: {
        type: 'ajax',
        data: [],
        url: server+'store.php',
        extraParams: {
            username: username
        },
        reader: {
            type: 'json',
            root: 'images',
            successProperty: 'success',
        }
    },
    
    getBounds: function() {
    	var x = this.get('left');
    	var y = this.get('top');
    	var w = this.picasa().getAt(0).get('width');
    	var h = this.picasa().getAt(0).get('height');
    	return [x,y,w,h];
    },
    
    getAffinityMap: function() {
    	var array = this.get('affinity');
    	var map = Ext.create('Ext.util.HashMap');
    	for(var i=0; i<array.length; i++) {
    		map.add(array[i][0],array[i][1]);
    	}
    	return map;
    },
    
    addAffinity: function(relatedId) {
    	var map = this.getAffinityMap();
    	var val = map.get(relatedId);
    	val = (typeof val === 'undefined') ? 1 : val+1;
    	map.replace(relatedId,val);
    	this.set('affinity',this.mapArray(map));
    },
    
    mapArray: function(map) {
    	var store = []; 
    	map.each(function(key,value) {
    		store.push([key,value]);
    	})
    	return store;
    },
    
    getSortedAffinity: function(top) {
    	var array = this.mapArray(this.getAffinityMap());
    	if(top==false) top=array.length;
    	array.sort(function(a,b) {
    		return b[1]-a[1];
    	})
    	return array.slice(0,top);
    }
});

/*{
'top': 0,
'left': 0,
'clicks': 0,
'picasa': [{
	'id': 'https://picasaweb.google.com/data/entry/api/user/103910795203149842497/albumid/5615080912899522545/photoid/5618021228476003058',
	'url': 'https://lh4.googleusercontent.com/-kExt8t5n6Oc/Tfc4iq_qcvI/AAAAAAAADOY/yLO7cajNrvc/Urlaub%2525202007-027.jpg',
	'width': 512,
	'height': 342
}*/